<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($title) ?></title>

  <!-- BOOTSTRAP -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="icon" href="<?= base_url('assets/images/logo1.png') ?>" type="image/png">

  <style>
    body{
      margin:0;
      font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial;
      background:#f5f7fb;
      color:#0f172a;
    }

    /* ===== SIDEBAR ===== */
    .sidebar{
      width:280px;
      min-height:100vh;
      background:#fff;
      overflow-y:auto;
    }
    .sidebar a{text-decoration:none}
    .sidebar .active{
      background:rgba(13,110,253,.12);
      border-radius:.5rem;
    }

    /* ===== MENU COLLAPSE ===== */
    .menu-toggle{
      cursor:pointer;
      position:relative;
      user-select:none;
    }
    .menu-toggle::after{
      content:'▸';
      position:absolute;
      right:1rem;
      font-size:.8rem;
      transition:transform .25s ease;
    }
    .menu-toggle:not(.collapsed)::after{
      transform:rotate(90deg);
    }

    .sub-menu{padding-left:1rem}
    .sub-menu .list-group-item{
      border:none;
      font-size:.9rem;
      padding:.45rem 1rem;
    }

    /* ===== RESPONSIVE ===== */
    .hamburger{
      display:none;
      font-size:1.6rem;
      color:#fff;
      cursor:pointer;
    }
    .sidebar-overlay{
      display:none;
      position:fixed;
      inset:0;
      background:rgba(0,0,0,.45);
      z-index:1040;
    }
    @media(max-width:991px){
      .hamburger{display:block}
      .sidebar{
        position:fixed;
        top:0;
        left:0;
        z-index:1050;
        transform:translateX(-100%);
        transition:.3s;
      }
      .sidebar.show{transform:translateX(0)}
      .sidebar-overlay.show{display:block}
    }

    .main-content{
      flex:1;
      min-width:0;
    }

    /* ===== TABLE KHUSUS EKSTRAKURIKULER ===== */
    .card{
      border-radius:16px;
      box-shadow:0 10px 25px rgba(0,0,0,.06);
    }
    table th{
      font-size:13px;
      font-weight:700;
    }
    .thumb{
      width:60px;
      height:60px;
      border-radius:12px;
      object-fit:cover;
      background:#e5e7eb;
    }
     /* ===== TAMBAHAN RESPONSIVE (AMAN) ===== */
     .hamburger {
      display: none;
      font-size: 1.6rem;
      color: #fff;
      cursor: pointer;
    }

    .sidebar-overlay {
      display: none;
      position: fixed;
      inset: 0;
      background: rgba(0,0,0,.45);
      z-index: 1040;
    }

    @media (max-width: 991px) {
      .hamburger {
        display: block;
      }

      .sidebar {
        position: fixed;
        top: 0;
        left: 0;
        z-index: 1050;
        background: #fff;
        transform: translateX(-100%);
        transition: transform .3s ease;
      }

      .sidebar.show {
        transform: translateX(0);
      }

      .sidebar-overlay.show {
        display: block;
      }
    }
  </style>
</head>

<body>

<body class="bg-light">

<nav class="navbar navbar-expand-lg bg-primary navbar-dark">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?= site_url('admin') ?>">Welcome back Admin</a>

    <!-- TAMBAHAN: HAMBURGER (TIDAK MENGHAPUS APA PUN) -->
    <span class="hamburger ms-auto me-3" onclick="toggleSidebar()">☰</span>

    <div class="d-flex gap-2 align-items-center">
      <span class="text-white small">Halo, <?= esc(auth()->user()->username ?? 'Admin') ?></span>
      <a class="btn btn-outline-light btn-sm" href="<?= site_url('logout') ?>">Logout</a>
    </div>
  </div>
</nav>

<!-- TAMBAHAN: OVERLAY -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="d-flex">

  <!-- ===== SIDEBAR ASLI KAMU (UTUH, TIDAK DIHAPUS) ===== -->
  <aside class="sidebar bg-white border-end p-3" id="sidebar">
    <div class="fw-bold mb-2">Admin Panel</div>

    <?php
      $uri = service('uri')->getPath();

      $isInfoSekolahActive = ($uri === 'admin' || $uri === 'admin/' ||
                              str_starts_with($uri, 'admin/branding') ||
                              str_starts_with($uri, 'admin/visi-misi') ||
                              str_starts_with($uri, 'admin/kepsek') ||
                              str_starts_with($uri, 'admin/video-profile') ||
                              str_starts_with($uri, 'admin/data-sekolah') ||
                              str_starts_with($uri, 'admin/footer'));

      $isBeritaActive = (str_starts_with($uri, 'admin/berita') ||
                        str_starts_with($uri, 'admin/pengumuman') ||
                        str_starts_with($uri, 'admin/kelulusan') ||
                        str_starts_with($uri, 'admin/kegiatan') ||
                        str_starts_with($uri, 'admin/prestasi'));

      $isGaleriActive = (str_starts_with($uri, 'admin/galeri') ||
                        str_starts_with($uri, 'admin/guru-staf') ||
                        str_starts_with($uri, 'admin/siswa') ||
                        str_starts_with($uri, 'admin/video') ||
                        str_starts_with($uri, 'admin/ekstrakulikuler'));
    ?>

    <div class="list-group list-group-flush">
      <!-- Informasi Sekolah -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isInfoSekolahActive ? '' : 'collapsed' ?> <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
         data-bs-toggle="collapse"
         href="#infoSekolahMenu"
         role="button"
         aria-expanded="<?= $isInfoSekolahActive ? 'true' : 'false' ?>"
         aria-controls="infoSekolahMenu">
        Informasi Sekolah
      </a>

      <div class="collapse <?= $isInfoSekolahActive ? 'show' : '' ?>" id="infoSekolahMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
             href="<?= site_url('admin') ?>">Dashboard</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/visi-misi') ? 'active' : '' ?>"
             href="<?= site_url('admin/visi-misi') ?>">Visi & Misi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kepsek') ? 'active' : '' ?>"
             href="<?= site_url('admin/kepsek') ?>">Kata Sambutan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video-profile') ? 'active' : '' ?>"
             href="<?= site_url('admin/video-profile') ?>">Video Profile</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/data-sekolah') ? 'active' : '' ?>"
             href="<?= site_url('admin/data-sekolah') ?>">Statistika</a>

             <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/footer') ? 'active' : '' ?>"
             href="<?= site_url('admin/footer') ?>">Footer</a>
        </div>
      </div>

      <!-- Berita -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isBeritaActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#beritaMenu"
         role="button"
         aria-expanded="<?= $isBeritaActive ? 'true' : 'false' ?>"
         aria-controls="beritaMenu">
        Berita
      </a>

      <div class="collapse <?= $isBeritaActive ? 'show' : '' ?>" id="beritaMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/pengumuman') ? 'active' : '' ?>"
             href="<?= site_url('admin/pengumuman') ?>">Pengumuman</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kelulusan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kelulusan') ?>">Pengumuman Kelulusan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kegiatan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kegiatan') ?>">Kegiatan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/prestasi') ? 'active' : '' ?>"
             href="<?= site_url('admin/prestasi') ?>">Prestasi</a>
        </div>
      </div>

      <!-- Galeri -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isGaleriActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#galeriMenu"
         role="button"
         aria-expanded="<?= $isGaleriActive ? 'true' : 'false' ?>"
         aria-controls="galeriMenu">
        Galeri
      </a>

      <div class="collapse <?= $isGaleriActive ? 'show' : '' ?>" id="galeriMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/guru-staf') ? 'active' : '' ?>"
             href="<?= site_url('admin/guru-staf') ?>">Guru dan Staf</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/siswa') ? 'active' : '' ?>"
             href="<?= site_url('admin/siswa') ?>">Siswa/Siswi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video') ? 'active' : '' ?>"
             href="<?= site_url('admin/video') ?>">Video</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/ekstrakurikuler') ? 'active' : '' ?>"
             href="<?= site_url('admin/ekstrakurikuler') ?>">Ekstrakulikuler</a>
        </div>
      </div>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/tentang') ? 'active' : '' ?>"
         href="<?= site_url('admin/tentang') ?>">Tentang</a>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/password') ? 'active' : '' ?>"
         href="<?= site_url('admin/password') ?>">Ubah Password</a>
    </div>
  </aside>


  <!-- MAIN CONTENT -->
  <main class="main-content p-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
      <div>
        <h3 class="fw-bold mb-1"><?= esc($title) ?></h3>
        <p class="text-muted mb-0">
          Kelola data ekstrakurikuler yang tampil di website
        </p>
      </div>

      <a href="<?= base_url('admin/ekstrakurikuler/create') ?>"
         class="btn btn-primary">
        + Tambah Ekstrakurikuler
      </a>
    </div>

    <?php if (session()->getFlashdata('msg')): ?>
      <div class="alert alert-success">
        <?= esc(session()->getFlashdata('msg')) ?>
      </div>
    <?php endif; ?>

    <div class="card">
      <div class="table-responsive">
        <table class="table table-bordered align-middle mb-0">
          <thead class="table-light">
            <tr>
              <th width="60">No</th>
              <th>Nama</th>
              <th>Pembina</th>
              <th>Anggota</th>
              <th>Urutan</th>
              <th>Foto</th>
              <th width="120">Aksi</th>
            </tr>
          </thead>
          <tbody>

          <?php if (empty($items)): ?>
            <tr>
              <td colspan="7" class="text-center text-muted">
                Belum ada data ekstrakurikuler.
              </td>
            </tr>
          <?php else: ?>
            <?php $no = 1; foreach ($items as $it): ?>
              <tr>
                <td><?= $no++ ?></td>
                <td><strong><?= esc($it['nama']) ?></strong></td>
                <td><?= esc($it['pembina'] ?? '-') ?></td>
                <td><?= esc($it['jumlah_anggota'] ?? '-') ?></td>
                <td><?= esc($it['urutan']) ?></td>
                <td>
                  <?php if (!empty($it['foto']) && is_file(FCPATH.'uploads/ekstrakurikuler/'.$it['foto'])): ?>
                    <img src="<?= base_url('uploads/ekstrakurikuler/'.$it['foto']) ?>"
                         class="thumb">
                  <?php else: ?>
                    <div class="thumb"></div>
                  <?php endif; ?>
                </td>
                <td>
                  <a href="<?= base_url('admin/ekstrakurikuler/edit/'.$it['id']) ?>"
                     class="btn btn-sm btn-warning">Edit</a>

                  <a href="<?= base_url('admin/ekstrakurikuler/delete/'.$it['id']) ?>"
                     class="btn btn-sm btn-danger"
                     onclick="return confirm('Yakin hapus data ini?')">
                    Hapus
                  </a>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>

          </tbody>
        </table>
      </div>
    </div>

  </main>
</div>

<!-- BOOTSTRAP JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
function toggleSidebar(){
  document.getElementById('sidebar').classList.toggle('show');
  document.querySelector('.sidebar-overlay').classList.toggle('show');
}
</script>

</body>
</html>
